
/******************************************************************************

Copyright (c) 2007, Niversoft Ides Logicielles
All rights reserved.

Redistribution and use in source and binary forms, with or without 
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright 
      notice, this list of conditions and the following disclaimer in the 
      documentation and/or other materials provided with the distribution.
    * Neither the name of Niversoft Ides Logicielles nor the names of its 
      contributors may be used to endorse or promote products derived from 
      this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

******************************************************************************/

#pragma once

using namespace System;
using namespace System::Collections;

namespace CommunigatePro 
{
   ref class DataSet;
}

namespace System { namespace Collections 
{
   public interface class IDataSetEnumerator : System::Collections::IEnumerator
   {
   public:
      virtual property CommunigatePro::DataSet ^ DataSet
      {
         CommunigatePro::DataSet ^ get();
      }
   };

   public interface class IDataSetDictionaryEnumerator : System::Collections::IDictionaryEnumerator
   {
   public:
      virtual property String ^ Name
      {
         String ^ get();
      }
      virtual property CommunigatePro::DataSet ^ DataSet
      {
         CommunigatePro::DataSet ^ get();
      }
   };

   private ref class DataSetEnumerator : IDataSetEnumerator
   {
      IEnumerator ^ m_Internal;

   public:

      DataSetEnumerator(IEnumerator ^ in_Internal) : m_Internal(in_Internal)
      {
      }

      virtual property Object ^ Current
      {
         Object ^ get()
         {
            return m_Internal->Current;
         }         
      }
      virtual property CommunigatePro::DataSet ^ DataSet
      {
         CommunigatePro::DataSet ^ get()
         {
            return (CommunigatePro::DataSet^)m_Internal->Current;
         }         
      }
      virtual bool MoveNext(void)
      {
         return m_Internal->MoveNext();
      }
      virtual void Reset(void)
      {
         return m_Internal->Reset();
      }
   };


   private ref class DataSetDictionaryEnumerator : IDataSetDictionaryEnumerator
   {
      IDictionaryEnumerator ^ m_Internal;

   public:

      DataSetDictionaryEnumerator(IDictionaryEnumerator ^ in_Internal) : m_Internal(in_Internal)
      {
      }

      virtual property Object ^ Current
      {
         Object ^ get()
         {
            return m_Internal->Current;
         }         
      }
      virtual property CommunigatePro::DataSet ^ DataSet
      {
         CommunigatePro::DataSet ^ get()
         {
            return (CommunigatePro::DataSet^)m_Internal->Value;
         }         
      }
      virtual property String ^ Name
      {
         String ^ get() { return (String^)m_Internal->Key; }
      }

      virtual bool MoveNext(void)
      {
         return m_Internal->MoveNext();
      }
      virtual void Reset(void)
      {
         return m_Internal->Reset();
      }
      virtual property Object ^ Key
      {
         Object ^ get() { return m_Internal->Key; }
      }
      virtual property Object ^ Value
      {
         Object ^ get() { return m_Internal->Value; }
      }
      virtual property DictionaryEntry Entry
      {
         DictionaryEntry get() { return m_Internal->Entry; }
      }
   };

   public ref class DataSetArray : System::Collections::CollectionBase
   {
   public:
      virtual property CommunigatePro::DataSet ^ default [int]
      {
	      CommunigatePro::DataSet ^ get (int index)    
         {
            return (CommunigatePro::DataSet^)List->default::get(index);
         }
	      void set (int index, CommunigatePro::DataSet ^ value)
         {
            List->default::set(index, value);
         }
      }
      int Add (CommunigatePro::DataSet ^ value)
      {
         return List->Add(value);
      }
      
      IDataSetEnumerator ^ GetDataSetEnumerator()
      {
         return gcnew DataSetEnumerator(GetEnumerator());
      }
   };

   public ref class DataSetMap : System::Collections::DictionaryBase
   {
   public:
      void Add (String^ key, CommunigatePro::DataSet^ value)
      {
         Dictionary->Add(key, value);
      }

      property CommunigatePro::DataSet ^ Item [String^]
      {
	      CommunigatePro::DataSet ^ get (String^ key)
         {
            return (CommunigatePro::DataSet^)Dictionary->default::get(key);
         }
	      void set (String^ key, CommunigatePro::DataSet ^ value)
         {
            Dictionary->default::set(key, value);
         }
      }

      IDataSetDictionaryEnumerator ^ GetDataSetEnumerator()
      {
         return gcnew DataSetDictionaryEnumerator(GetEnumerator());
      }
   };
}}

namespace CommunigatePro
{
	public ref class DataSet
	{
   public:
      enum class DataSetType
      {
         Null,
         String,
         Array,
         Dictionary         
      };

      DataSet() : m_Type(DataSetType::Null)
      {
      }

      DataSet(DataSet::DataSetType in_Type) : m_Type(in_Type)
      {
         switch(m_Type)
         {
         case DataSet::DataSetType::Array:
            ArrayValue = gcnew DataSetArray();
            break;
         case DataSet::DataSetType::Dictionary:
            DictionaryValue = gcnew DataSetMap();
            break;
         case DataSet::DataSetType::String:
            StringValue = "";
            break;
         }
      }


   private:
      DataSet::DataSetType    m_Type;

   public:      
      String ^        StringValue;
      DataSetArray ^  ArrayValue;
      DataSetMap ^    DictionaryValue;

      bool  IsNull()
      {
         return m_Type == DataSet::DataSetType::Null;
      }

      DataSet::DataSetType Type()
      {
         return m_Type;
      }

      static DataSet ^ String(String ^ value)
      {
         DataSet ^ l_DataSet = gcnew DataSet(DataSetType::String);
         l_DataSet->StringValue = value;
         return l_DataSet;
      }
   };
}
