#!/usr/bin/perl

use strict;

###############################################################################
#
# This file can be distributed and modified freely, as long as this original
# header is not modified and the signature header
#      "X-ExtScanner: Niversoft's RemoveHeaders on %domain% (free)
# still added to scanned messages. Ok I know that adding a header for a header
# remover script is a bit weird, but hey, you didn't pay for the script, no?
# Anyway a header must be added somewhere to prevent infinite loops in CGP rules
#
# Nicolas Hatier <nicolas.hatier@niversoft.com>, Niversoft idees logicielles
# Date: November 2005
#
# This code is provided AS IS
#
###############################################################################
#
# This script is a Content-Filtering script for Communigate Pro.
# The purpose of this script is to remove extraneous headers from emails.
#
# This script doesn't have any dependency except Perl itself.
#
#  In CGPro, add this rule, with the lowest priority (this rule must be the
#  last one to run):
#
#  ANY ROUTE     is     SMTP(*
#
#  Action: Execute   [RETPATH][RCPT] /usr/bin/perl Filters/RemoveHeaders.pl
#          Discard
#
#
# You will also need another rule to prevent infinite loops. Set it to the
# highest priority so the messages aren't processed twice:
#
#	Header Field  is X-ExtScanner: Niversoft's RemoveHeaders on %domain%
#  Action: Stop Processing
#
#  (replace %domain% by your domain name, or anything you put in the
#   $YourDomain variable below)
#
#
# Please ensure that your PIPE module is configured with a positve
# processor count and an appropriate time under "Check Submitted
# Directory Every" - to ensure the mail is enqueued and sent correctly.
#

#######################################################################################
# Your Domain Name
#######################################################################################
# Only used to be sure another server's RemoveHeader filter doesn't
# clash with yours and break your rules processing. The recommended value is your
# domain name, but can be anything
my $MyDomain = "domain.com";


my $HeadersToRemove  = <<END;
#######################################################################################
# Headers to remove
#######################################################################################
# Configure the headers you want to be removed. All header lines starting by
# these strings will be removed. Be sure to specify the colon character, or partial
# headers could be matched ("X-Mailer" would match both "X-Mailer:" and "X-Mailer-Version:"
# Put one header by line. Blank lines and lines beginning by "#" will be ignored.
# Matching is not case-sensitive.

X-Mailer:
Organization:
X-CGP-ClamAV-Result: CLEAN
X-VirusScanner
Received:

#######################################################################################
# Main Program, nothing to modify below this line
#######################################################################################
END



exit(main());


sub main
{
   print "Removing extraneous headers...\n";
   my %HeadersToRemove = ();

   my @HeadersToRemove = ();
   foreach my $Header (split(/\n/, $HeadersToRemove))
   {
      next if ($Header =~ /^#/);
      $Header =~ s/^ +//g;
      $Header =~ s/ +$//g;
      $Header =~ s/[\r\n]//g;
      next unless(length $Header);
      push @HeadersToRemove, $Header;
   }

	my $dest = 0;
	my @recipients;
	my $returnpath;
	foreach (@ARGV)
	{
	   if(/^-p$/)
	   {
	      $dest = 0;
	   }
	   elsif(/^-r$/)
	   {
	      $dest = 1;
	   }
	   elsif($dest)
	   {
	      push @recipients, $_;
	   }
	   else
	   {
	      $returnpath = $_;
	   }
	}

   mkdir ("Submitted") unless (-d "Submitted");
	my $filename = "Submitted/outfile" . time.int(rand(10000000));
	$filename .= "_" while ((-f "$filename.tmp") || (-f "$filename.sub"));

	open OUTPUT, ">$filename.tmp";
	select OUTPUT;
	print "Return-Path: $returnpath\n";
	foreach (@recipients)
	{
	   print "Envelope-To: $_\n";
	}
	print "X-ExtScanner: Niversoft's RemoveHeaders on $MyDomain\n";

   my $line;
   my @unfolded = ();
   while ($line = <STDIN>)
   {
      $line =~ s/[\r\n]//g;

      if ($line =~ /^[ \t]/)
      {
         push @unfolded, $line;
      }
      else
      {
         if (scalar @unfolded)
         {
            my $found = 0;
            foreach my $Header (@HeadersToRemove)
            {
               if ($unfolded[0] =~ /^\Q$Header\E/i)
               {
                  $found = 1;
                  last;
               }
            }
            print join("\n", @unfolded) . "\n" unless($found);
            @unfolded = ();
         }
         push @unfolded, $line;
      }
      last if (!length $line);
   }

   print "\n";
   while ($line = <STDIN>)
   {
      print $line;
   }

   close(select(STDOUT));
   rename ("$filename.tmp", "$filename.sub");
   return 0;
}